/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.panda_lang.panda.utilities.annotations.AnnotationScannerStore;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerProcess;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerUtils;
import org.panda_lang.panda.utilities.annotations.monads.AnnotationsSelector;
import org.panda_lang.panda.utilities.annotations.monads.selectors.SubTypeSelector;
import org.panda_lang.panda.utilities.annotations.monads.selectors.TypeAnnotationSelector;
import org.panda_lang.panda.utilities.commons.objects.TimeUtils;

public class AnnotationsScannerSelector {
    private final AnnotationsScannerProcess process;
    private final AnnotationScannerStore store;

    public AnnotationsScannerSelector(AnnotationsScannerProcess process, AnnotationScannerStore store) {
        this.process = process;
        this.store = store;
    }

    public Set<Class<?>> select(AnnotationsSelector selector) {
        long uptime = System.nanoTime();
        Collection<String> selected = selector.select(this.process, this.store);
        Set<Class<?>> classes = AnnotationsScannerUtils.forNames(this.process.getScanner(), selected);
        this.process.getScanner().getLogger().debug("Selected classes: " + classes.size() + " in " + TimeUtils.toMilliseconds(System.nanoTime() - uptime));
        return classes;
    }

    public <T> Set<Class<? extends T>> selectSubtypesOf(Class<? extends T> type) {
        HashSet<Class<T>> selectedClasses = new HashSet<Class<T>>();
        for (Class<?> clazz : this.select(new SubTypeSelector(type))) {
            selectedClasses.add(clazz);
        }
        return selectedClasses;
    }

    public Set<Class<?>> selectTypesAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.select(new TypeAnnotationSelector(annotationType));
    }
}

