/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.adapter;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScanner;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerFile;
import org.panda_lang.panda.utilities.annotations.adapter.MetadataAdapter;
import org.panda_lang.panda.utilities.commons.io.IOUtils;
import org.panda_lang.panda.utilities.commons.redact.ContentJoiner;

public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static boolean includeInvisibleTag = true;

    @Override
    public List<FieldInfo> getFields(ClassFile cls) {
        return cls.getFields();
    }

    @Override
    public List<MethodInfo> getMethods(ClassFile cls) {
        return cls.getMethods();
    }

    @Override
    public String getMethodName(MethodInfo method) {
        return method.getName();
    }

    @Override
    public List<String> getParameterNames(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.indexOf("(") + 1, descriptor.lastIndexOf(")"));
        return this.splitDescriptorToTypeNames(descriptor);
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)aClass.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getFieldAnnotationNames(FieldInfo field) {
        return this.getAnnotationNames((AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)field.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getMethodAnnotationNames(MethodInfo method) {
        return this.getAnnotationNames((AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getParameterAnnotationNames(MethodInfo method, int parameterIndex) {
        ArrayList<String> result = new ArrayList<String>();
        List<ParameterAnnotationsAttribute> parameterAnnotationsAttributes = Arrays.asList((ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations"), (ParameterAnnotationsAttribute)method.getAttribute("RuntimeInvisibleParameterAnnotations"));
        for (ParameterAnnotationsAttribute parameterAnnotationsAttribute : parameterAnnotationsAttributes) {
            Annotation[][] annotations;
            if (parameterAnnotationsAttribute == null || parameterIndex >= (annotations = parameterAnnotationsAttribute.getAnnotations()).length) continue;
            Annotation[] annotation = annotations[parameterIndex];
            result.addAll(this.getAnnotationNames(annotation));
        }
        return result;
    }

    @Override
    public String getReturnTypeName(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        return this.splitDescriptorToTypeNames(descriptor).get(0);
    }

    @Override
    public String getFieldName(FieldInfo field) {
        return field.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClassFile getOfCreateClassObject(AnnotationsScanner scanner, AnnotationsScannerFile file) {
        InputStream inputStream = null;
        try {
            inputStream = file.openInputStream();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream));
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (Exception e) {
            scanner.getLogger().exception(e);
            scanner.getLogger().error("Could not create class file from " + file.getInternalPath());
        }
        finally {
            IOUtils.close(inputStream);
        }
        return null;
    }

    @Override
    public String getMethodModifier(MethodInfo method) {
        int accessFlags = method.getAccessFlags();
        return AccessFlag.isPrivate(accessFlags) ? "private" : (AccessFlag.isProtected(accessFlags) ? "protected" : (this.isPublic(accessFlags) ? "public" : ""));
    }

    @Override
    public String getMethodKey(ClassFile cls, MethodInfo method) {
        return this.getMethodName(method) + "(" + ContentJoiner.on(", ").join(this.getParameterNames(method)) + ")";
    }

    @Override
    public String getMethodFullKey(ClassFile cls, MethodInfo method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    @Override
    public boolean isPublic(Object o) {
        int accessFlags = o instanceof ClassFile ? ((ClassFile)o).getAccessFlags() : (o instanceof FieldInfo ? ((FieldInfo)o).getAccessFlags() : (o instanceof MethodInfo ? Integer.valueOf(((MethodInfo)o).getAccessFlags()) : null).intValue());
        return AccessFlag.isPublic(accessFlags);
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        ArrayList<String> result = new ArrayList<String>();
        if (annotationsAttributes == null) {
            return result;
        }
        for (AnnotationsAttribute annotationsAttribute : annotationsAttributes) {
            if (annotationsAttribute == null) continue;
            for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                result.add(annotation.getTypeName());
            }
        }
        return result;
    }

    private List<String> getAnnotationNames(Annotation[] annotations) {
        ArrayList<String> result = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            result.add(annotation.getTypeName());
        }
        return result;
    }

    private List<String> splitDescriptorToTypeNames(String descriptors) {
        ArrayList<String> result = new ArrayList<String>();
        if (descriptors != null && descriptors.length() != 0) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            Descriptor.Iterator iterator = new Descriptor.Iterator(descriptors);
            while (iterator.hasNext()) {
                indices.add(iterator.next());
            }
            indices.add(descriptors.length());
            for (int i = 0; i < indices.size() - 1; ++i) {
                String s1 = Descriptor.toString(descriptors.substring((Integer)indices.get(i), (Integer)indices.get(i + 1)));
                result.add(s1);
            }
        }
        return result;
    }
}

