/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.monads.filters;

import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerFile;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerUtils;
import org.panda_lang.panda.utilities.annotations.adapter.MetadataAdapter;
import org.panda_lang.panda.utilities.annotations.monads.AnnotationsFilter;

public class PackageFileFilter
implements AnnotationsFilter<AnnotationsScannerFile> {
    private final boolean exclude;
    private final String[] packages;

    public PackageFileFilter(boolean exclude, String ... packages) {
        this.exclude = exclude;
        this.packages = packages;
    }

    @Override
    public boolean check(MetadataAdapter<ClassFile, FieldInfo, MethodInfo> metadataAdapter, AnnotationsScannerFile element) {
        for (String packageName : this.packages) {
            if (AnnotationsScannerUtils.toClassPath(element.getOriginalPath()).startsWith(packageName)) {
                return !this.exclude;
            }
            if (!AnnotationsScannerUtils.toClassPath(element.getInternalPath()).startsWith(packageName)) continue;
            return !this.exclude;
        }
        return this.exclude;
    }
}

