/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.monads.selectors;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.panda_lang.panda.utilities.annotations.AnnotationScannerStore;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerProcess;
import org.panda_lang.panda.utilities.annotations.monads.AnnotationsSelector;

public class TypeAnnotationSelector
implements AnnotationsSelector {
    private Class<? extends Annotation> annotationType;

    public TypeAnnotationSelector(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Collection<String> select(AnnotationsScannerProcess process, AnnotationScannerStore store) {
        HashSet<String> selectedClasses = new HashSet<String>();
        block0: for (ClassFile classFile : store.getCachedClassFiles()) {
            List<String> annotationNames = process.getMetadataAdapter().getClassAnnotationNames(classFile);
            for (String annotationName : annotationNames) {
                if (!this.annotationType.getName().equals(annotationName)) continue;
                selectedClasses.add(classFile.getName());
                continue block0;
            }
        }
        return selectedClasses;
    }
}

