/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.resource;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerFile;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.resource.JarAnnotationsScannerFile;
import org.panda_lang.panda.utilities.commons.io.IOUtils;

class JarAnnotationsScannerResource
extends AnnotationsScannerResource<AnnotationsScannerFile>
implements Closeable {
    protected JarInputStream jarInputStream;
    protected long cursor = 0L;
    protected long nextCursor = 0L;

    JarAnnotationsScannerResource(URL url) {
        super(url);
    }

    @Override
    public Iterator<AnnotationsScannerFile> iterator() {
        try {
            this.jarInputStream = new JarInputStream(this.getLocation().openConnection().getInputStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open url connection", e);
        }
        return new Iterator<AnnotationsScannerFile>(){
            private ZipEntry entry;

            @Override
            public boolean hasNext() {
                try {
                    this.entry = JarAnnotationsScannerResource.this.jarInputStream.getNextJarEntry();
                    if (this.entry != null && !this.entry.getName().endsWith(".class")) {
                        return this.hasNext();
                    }
                    return this.entry != null;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            @Nullable
            public AnnotationsScannerFile next() {
                while (this.entry != null) {
                    long size = this.entry.getSize();
                    if (size < 0L) {
                        size = 0xFFFFFFFFL + size;
                    }
                    JarAnnotationsScannerResource.this.nextCursor += size;
                    if (!this.entry.isDirectory()) {
                        return new JarAnnotationsScannerFile(JarAnnotationsScannerResource.this, this.entry, JarAnnotationsScannerResource.this.cursor, JarAnnotationsScannerResource.this.nextCursor);
                    }
                    if (this.hasNext()) continue;
                    break;
                }
                return null;
            }
        };
    }

    @Override
    public Iterable<AnnotationsScannerFile> getFiles() {
        return this;
    }

    @Override
    public void close() {
        IOUtils.close(this.jarInputStream);
    }
}

