/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.autodata.collection;

import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.autodata.AutomatedDataRest;
import org.panda_lang.panda.utilities.autodata.collection.ADSCollectionBuilder;
import org.panda_lang.panda.utilities.autodata.collection.ADSCollectionHandler;
import org.panda_lang.panda.utilities.autodata.collection.ADSCollectionService;

public class ADSCollection<T>
implements AutomatedDataRest<T> {
    private final Class<T> type;
    private final String name;
    private final ADSCollectionService service;
    private final Map<Class<?>, ADSCollectionHandler> handlers;

    protected ADSCollection(ADSCollectionBuilder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.service = builder.service;
        this.handlers = builder.handlers;
    }

    @Override
    @Nullable
    public T get(Object query) {
        for (Map.Entry<Class<?>, ADSCollectionHandler> entry : this.handlers.entrySet()) {
            if (entry.getKey() != query.getClass()) continue;
            ADSCollectionHandler handler = entry.getValue();
            Object value = handler.get(this.service, query);
            return (T)value;
        }
        return null;
    }

    @Override
    public void post(Object element) {
        for (Map.Entry<Class<?>, ADSCollectionHandler> entry : this.handlers.entrySet()) {
            ADSCollectionHandler handler = entry.getValue();
            if (handler.getDataType() != element.getClass()) continue;
            handler.save(this.service, element);
        }
    }

    @Override
    public void patch(Object element) {
    }

    @Override
    public T put(Object element) {
        return null;
    }

    @Override
    public T delete(Object query) {
        return null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

