/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.pattern.charset;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;
import org.panda_lang.panda.utilities.commons.arrays.CharArrayDistributor;
import org.panda_lang.panda.utilities.commons.pattern.PatternMatcher;

public class CharsetPattern
implements PatternMatcher,
Comparable<CharsetPattern> {
    private final String pattern;
    private char[] charset;
    private double priority;

    public CharsetPattern(String pattern, char[] charset, double priority) {
        this(pattern, charset);
        this.priority = priority;
    }

    public CharsetPattern(String pattern, char[] charset) {
        this(pattern);
        this.charset = (char[])charset.clone();
    }

    public CharsetPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean match(String s) {
        char[] string = s.toCharArray();
        int i = 0;
        if (string.length == 0 && this.getPattern().length() == 0) {
            return false;
        }
        CharArrayDistributor distributor = new CharArrayDistributor(this.getPattern().toCharArray());
        distributor.next();
        while (distributor.hasNext() && i < string.length) {
            char current = distributor.current();
            if (current == string[i]) {
                distributor.next();
                ++i;
                continue;
            }
            if (current != '*') break;
            if (distributor.further() == string[i]) {
                distributor.next();
                distributor.next();
            }
            ++i;
        }
        return !distributor.hasNext();
    }

    public int count(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public char getNext(char[] array, int current) {
        return current + 1 < array.length ? array[current + 1] : array[current];
    }

    public void setCharset(char[] charset) {
        this.charset = (char[])charset.clone();
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public String getPattern() {
        return this.pattern;
    }

    public char[] getCharset() {
        return (char[])this.charset.clone();
    }

    public double getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(CharsetPattern pattern) {
        if (Objects.equals(this, pattern)) {
            return 0;
        }
        if (pattern == null) {
            throw new InvalidParameterException("Pattern is null");
        }
        double priority = this.priority;
        double priorityTo = pattern.getPriority();
        if (priorityTo == 0.0 && priority == 0.0) {
            priority = this.count(this.getPattern(), '*');
            priorityTo = this.count(pattern.getPattern(), '*');
        } else if (priorityTo == priority) {
            return 0;
        }
        if (Double.compare(priority, priorityTo) == 0) {
            priority = this.getPattern().length();
            priorityTo = pattern.getPattern().length();
        }
        return Double.compare(priority, priorityTo);
    }

    public int hashCode() {
        int result = Objects.hash(this.pattern, this.priority);
        result = 31 * result + Arrays.hashCode(this.charset);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharsetPattern that = (CharsetPattern)o;
        return Double.compare(that.priority, this.priority) == 0 && Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.charset, that.charset);
    }

    public String toString() {
        return this.pattern;
    }
}

