/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.pattern.charset;

import java.util.Stack;

public class CharsetPatternExtractor {
    public static final char[] DEFAULT = "*^!?/[]{}()<>&#@;:=".toCharArray();
    public static final char[] FULL = "abcdefghijklmnopqrstuvwxyz!?/[]{}()<>#;:=-".toCharArray();
    public static final char[] EQUALITY = "|!&<>=".toCharArray();
    public static final char[] METHOD = "()".toCharArray();

    public String extract(String line, char[] set) {
        if (line == null) {
            return "";
        }
        StringBuilder pattern = new StringBuilder();
        Stack<Character> sections = new Stack<Character>();
        boolean string = false;
        block4: for (char c : line.toCharArray()) {
            if (c == '\"') {
                string = !string;
                continue;
            }
            if (string) continue;
            switch (c) {
                case '(': {
                    sections.push(Character.valueOf(c));
                    break;
                }
                case ')': {
                    sections.pop();
                    break;
                }
                default: {
                    if (sections.size() > 0) continue block4;
                }
            }
            for (char s : set) {
                if (s != c) continue;
                pattern.append(c);
                continue block4;
            }
        }
        return pattern.toString();
    }
}

