/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.pattern.text;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowPattern;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowPatternCompiler;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowSymbol;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowSymbolType;

public class TextHollowPatternBuilder {
    private final List<TextHollowSymbol> hollowSymbols = new ArrayList<TextHollowSymbol>();
    private TextHollowSymbol hollowSymbol;

    protected TextHollowPatternBuilder() {
    }

    public TextHollowPatternBuilder basis(String basis) {
        this.hollowSymbol = new TextHollowSymbol(TextHollowSymbolType.BASIS, this.hollowSymbols.size());
        this.hollowSymbols.add(this.hollowSymbol);
        this.hollowSymbol.addVariant(basis);
        return this;
    }

    public TextHollowPatternBuilder variant(String variant) {
        this.hollowSymbol.addVariant(variant);
        return this;
    }

    public TextHollowPatternBuilder hollow() {
        this.hollowSymbol = new TextHollowSymbol(TextHollowSymbolType.HOLLOW, this.hollowSymbols.size());
        this.hollowSymbols.add(this.hollowSymbol);
        return this;
    }

    public TextHollowPatternBuilder optional(String fragment) {
        this.hollowSymbol = new TextHollowSymbol(TextHollowSymbolType.OPTIONAL, this.hollowSymbols.size());
        this.hollowSymbols.add(this.hollowSymbol);
        this.hollowSymbol.addVariant(fragment);
        return this;
    }

    public TextHollowPatternBuilder optionalSegmentBefore(String segment) {
        this.hollowSymbol.addSegmentBefore(segment);
        return this;
    }

    public TextHollowPatternBuilder optionalSegmentAfter(String segment) {
        this.hollowSymbol.addSegmentAfter(segment);
        return this;
    }

    public TextHollowPatternBuilder compile(String pattern) {
        return this.compiler().compile(pattern);
    }

    public TextHollowPatternCompiler compiler() {
        return new TextHollowPatternCompiler(this);
    }

    public TextHollowPattern build() {
        return new TextHollowPattern(this.hollowSymbols);
    }
}

