/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.redact;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.panda_lang.panda.utilities.commons.arrays.CharArrayDistributor;
import org.panda_lang.panda.utilities.commons.redact.BracketContentReader;

public class AttentiveContentReader {
    private final CharArrayDistributor distributor;
    private char[] openingSequence = BracketContentReader.OPENING_SEQUENCE;
    private char[] closingSequence = BracketContentReader.CLOSING_SEQUENCE;

    public AttentiveContentReader(CharArrayDistributor distributor) {
        this.distributor = distributor;
    }

    public AttentiveContentReader(String pattern) {
        this(new CharArrayDistributor(pattern));
    }

    public List<String> select(char separator) {
        int index = this.distributor.getIndex();
        ArrayList<String> selected = new ArrayList<String>();
        StringBuilder content = new StringBuilder();
        Stack<Character> sequences = new Stack<Character>();
        while (this.distributor.hasNext()) {
            char current = this.distributor.next();
            if (current == separator && sequences.size() == 0) {
                selected.add(content.toString());
                content.setLength(0);
                continue;
            }
            BracketContentReader.verifySequences(sequences, this.openingSequence, this.closingSequence, current);
            content.append(current);
        }
        if (content.length() > 0) {
            selected.add(content.toString());
        }
        this.distributor.setIndex(index);
        return selected;
    }

    public void setOpeningSequence(char[] openingSequence) {
        this.openingSequence = openingSequence;
    }

    public void setClosingSequence(char[] closingSequence) {
        this.closingSequence = closingSequence;
    }
}

