/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.redact;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class MessageFormatter {
    private final Map<String, Supplier<?>> placeholders;

    public MessageFormatter(Map<String, Supplier<?>> placeholders) {
        this.placeholders = placeholders;
    }

    public MessageFormatter() {
        this(new HashMap());
    }

    public String format(String message) {
        for (Map.Entry<String, Supplier<?>> placeholderEntry : this.placeholders.entrySet()) {
            String key = placeholderEntry.getKey();
            Object value = placeholderEntry.getValue().get();
            if (!message.contains(key)) continue;
            message = StringUtils.replace(message, key, value != null ? value.toString() : "<value not specified>");
        }
        return message;
    }

    public MessageFormatter register(String placeholder, Object value) {
        return this.register(placeholder, value::toString);
    }

    public MessageFormatter register(String placeholder, Supplier<?> value) {
        this.placeholders.put(placeholder, value);
        return this;
    }

    public MessageFormatter fork() {
        return new MessageFormatter(new HashMap(this.placeholders));
    }

    public <T> T getValue(String placeholder) {
        Supplier<?> supplier = this.placeholders.get(placeholder);
        return (T)supplier.get();
    }
}

