/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.redact.divider;

import java.util.Iterator;
import java.util.Stack;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;
import org.panda_lang.panda.utilities.commons.redact.divider.DividerRules;
import org.panda_lang.panda.utilities.commons.redact.divider.DividerSeparator;
import org.panda_lang.panda.utilities.commons.redact.divider.DividerSequence;
import org.panda_lang.panda.utilities.commons.redact.divider.Fragment;

public class Divider
implements Iterable<Fragment>,
Iterator<Fragment> {
    private final char[] source;
    private final DividerRules dividerRules;
    private final Stack<DividerSequence> sequenceStack;
    private final StringBuilder indentionBuilder;
    private final StringBuilder nodeBuilder;
    private DividerSeparator latestSeparator;
    private Fragment previousFragment;
    private Fragment currentFragment;
    private String node;
    private int inline;
    private int nodes;
    private int line;
    private int caret;

    public Divider(String source, DividerRules dividerRules) {
        this.source = source.toCharArray();
        this.dividerRules = dividerRules;
        this.nodeBuilder = new StringBuilder();
        this.indentionBuilder = new StringBuilder();
        this.sequenceStack = new Stack();
        this.caret = -1;
        this.line = 1;
    }

    @Override
    public Fragment next() {
        this.inline = 0;
        ++this.caret;
        block0: while (this.caret < this.source.length) {
            char currentChar = this.source[this.caret];
            if (this.nodeBuilder.length() == 0 && CharacterUtils.isWhitespace(currentChar)) {
                this.indentionBuilder.append(currentChar);
            } else {
                this.nodeBuilder.append(currentChar);
                this.node = this.nodeBuilder.toString();
                if (this.node.endsWith(System.lineSeparator())) {
                    ++this.line;
                }
                for (DividerSequence sequence : this.dividerRules.getSequences()) {
                    String sequenceStart = sequence.getSequenceStart();
                    if (this.sequenceStack.size() != 0) {
                        DividerSequence previousSequence = this.sequenceStack.peek();
                        if (!this.node.endsWith(previousSequence.getSequenceEnd())) continue;
                        this.sequenceStack.pop();
                        break;
                    }
                    if (!this.node.endsWith(sequenceStart)) continue;
                    this.sequenceStack.push(sequence);
                    break;
                }
                if (this.sequenceStack.size() == 0) {
                    for (DividerSeparator separator : this.dividerRules.getSeparators()) {
                        if (!this.node.endsWith(separator.getTokenValue())) continue;
                        this.node = this.node.substring(0, this.node.length() - separator.getTokenValue().length());
                        this.latestSeparator = separator;
                        break block0;
                    }
                }
            }
            ++this.caret;
            ++this.inline;
        }
        Fragment fragment = new Fragment(this.node);
        fragment.setIndention(this.indentionBuilder.toString());
        fragment.setSeparator(this.latestSeparator);
        fragment.setInline(this.inline);
        fragment.setLine(this.line);
        this.previousFragment = this.currentFragment;
        this.currentFragment = fragment;
        this.indentionBuilder.setLength(0);
        this.nodeBuilder.setLength(0);
        ++this.nodes;
        return this.currentFragment;
    }

    @Override
    public Iterator<Fragment> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.caret + 1 >= this.source.length) {
            return false;
        }
        for (int i = this.caret + 1; i < this.source.length; ++i) {
            char character = this.source[i];
            if (CharacterUtils.isWhitespace(character)) continue;
            return true;
        }
        return false;
    }

    public String getNode() {
        return this.node;
    }

    public DividerRules getDividerRules() {
        return this.dividerRules;
    }

    public Fragment getPreviousFragment() {
        return this.previousFragment;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getLine() {
        return this.line;
    }

    public int getInlineCaretPosition() {
        return this.inline;
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public char[] getSource() {
        return this.source;
    }
}

