/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.loader;

import java.util.ArrayList;
import java.util.Collection;
import org.panda_lang.pandomium.Pandomium;
import org.panda_lang.pandomium.loader.PandomiumLoaderWorker;
import org.panda_lang.pandomium.loader.PandomiumProgressListener;
import org.panda_lang.pandomium.settings.PandomiumSettings;
import org.panda_lang.pandomium.settings.categories.LoaderSettings;

public class PandomiumLoader {
    private final Pandomium pandomium;
    private final Collection<PandomiumProgressListener> progressListeners;
    private int progress;

    public PandomiumLoader(Pandomium pandomium) {
        this.pandomium = pandomium;
        this.progressListeners = new ArrayList<PandomiumProgressListener>();
    }

    public void load() {
        Pandomium.getLogger().info("#");
        Pandomium.getLogger().info("# Launching Pandomium " + Pandomium.getVersion());
        Pandomium.getLogger().info("# Chromium Version: " + Pandomium.getChromiumVersion());
        Pandomium.getLogger().info("# CEF Version: " + Pandomium.getCefVersion());
        Pandomium.getLogger().info("#");
        PandomiumSettings settings = this.pandomium.getSettings();
        LoaderSettings loaderSettings = settings.getLoader();
        this.progressListeners.add((state, progress) -> {
            if (state == PandomiumProgressListener.State.RUNNING) {
                Pandomium.getLogger().info("Progress: " + progress + "%");
            }
        });
        PandomiumLoaderWorker worker = new PandomiumLoaderWorker(this);
        if (!loaderSettings.isLoadAsync()) {
            worker.run();
            return;
        }
        Thread loaderThread = new Thread((Runnable)worker, "Pandomium Loader Thread");
        loaderThread.start();
    }

    protected void updateProgress(int newProgress) {
        this.progress = newProgress;
        this.callListeners(PandomiumProgressListener.State.RUNNING);
    }

    protected void callListeners(PandomiumProgressListener.State state) {
        for (PandomiumProgressListener listener : this.progressListeners) {
            listener.onUpdate(state, this.progress);
        }
    }

    public void addProgressListener(PandomiumProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public Collection<PandomiumProgressListener> getProgressListeners() {
        return this.progressListeners;
    }

    public int getProgress() {
        return this.progress;
    }

    public Pandomium getPandomium() {
        return this.pandomium;
    }
}

