/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.settings;

import org.cef.CefSettings;
import org.panda_lang.pandomium.settings.PandomiumSettingsBuilder;
import org.panda_lang.pandomium.settings.categories.CommandLineSettings;
import org.panda_lang.pandomium.settings.categories.DependenciesSettings;
import org.panda_lang.pandomium.settings.categories.LoaderSettings;
import org.panda_lang.pandomium.settings.categories.NativesSettings;
import org.panda_lang.pandomium.util.os.PandomiumOS;
import org.panda_lang.pandomium.util.os.PandomiumOSType;

public class PandomiumSettings {
    private final CommandLineSettings commandLine;
    private final DependenciesSettings dependencies;
    private final NativesSettings natives;
    private final LoaderSettings loader;
    private final CefSettings cef;

    protected PandomiumSettings(CommandLineSettings commandLine, DependenciesSettings dependencies, NativesSettings natives, LoaderSettings loader) {
        this.commandLine = commandLine;
        this.dependencies = dependencies;
        this.natives = natives;
        this.loader = loader;
        this.cef = new CefSettings();
        this.cef.windowless_rendering_enabled = PandomiumOS.isLinux();
    }

    public LoaderSettings getLoader() {
        return this.loader;
    }

    public NativesSettings getNatives() {
        return this.natives;
    }

    public DependenciesSettings getDependencies() {
        return this.dependencies;
    }

    public CommandLineSettings getCommandLine() {
        return this.commandLine;
    }

    public CefSettings getCefSettings() {
        return this.cef;
    }

    public static PandomiumSettingsBuilder builder() {
        return new PandomiumSettingsBuilder();
    }

    public static PandomiumSettingsBuilder getDefaultSettingsBuilder() {
        return PandomiumSettings.builder().dependencyURL(PandomiumOSType.OS_WINDOWS, "https://pandomium.panda-lang.org/download/natives/67.0/win64-natives.tar.xz").dependencyURL(PandomiumOSType.OS_MAC, "https://pandomium.panda-lang.org/download/natives/67.0/mac64-natives.tar.xz").dependencyURL(PandomiumOSType.OS_LINUX, "https://pandomium.panda-lang.org/download/natives/67.0/linux64-natives.tar.xz").nativeDirectory("natives").loadAsync(false);
    }

    public static PandomiumSettings getDefaultSettings() {
        return PandomiumSettings.getDefaultSettingsBuilder().build();
    }
}

