/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourcesUtils {
    public static Collection<String> getResources(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> resources = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(System.getProperty("path.separator"))) {
            resources.addAll(ResourcesUtils.getResources(element, pattern));
        }
        return resources;
    }

    private static Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(ResourcesUtils.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(ResourcesUtils.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> resources = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            resources.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return resources;
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return resources;
        }
        for (File file : fileList) {
            if (file.isDirectory()) {
                resources.addAll(ResourcesUtils.getResourcesFromDirectory(file, pattern));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                resources.add(fileName);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return resources;
    }
}

