/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.util.os;

import org.panda_lang.pandomium.util.os.PandomiumOSType;

public class PandomiumOS {
    private static final PandomiumOSType OS = PandomiumOS.getOSType();

    public static boolean isWindows() {
        return PandomiumOS.getOSType() == PandomiumOSType.OS_WINDOWS;
    }

    public static boolean isMacOS() {
        return PandomiumOS.getOSType() == PandomiumOSType.OS_MAC;
    }

    public static boolean isLinux() {
        return PandomiumOS.getOSType() == PandomiumOSType.OS_LINUX;
    }

    private static PandomiumOSType getOSType() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return PandomiumOSType.OS_WINDOWS;
        }
        if (os.startsWith("linux")) {
            return PandomiumOSType.OS_LINUX;
        }
        if (os.startsWith("mac")) {
            return PandomiumOSType.OS_MAC;
        }
        return PandomiumOSType.UNKNOWN;
    }

    public static PandomiumOSType getOS() {
        return OS;
    }
}

