/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

class JcaCertificateTest {
    JcaCertificateTest() {
    }

    public static void main(String[] a) {
        a = new String[]{"/home/marcarvalho/Dropbox/cert/MarcoCarvalho.cer", "/home/marcarvalho/Dropbox/cert/xpto.txt"};
        if (a.length < 2) {
            System.out.println("Usage:");
            System.out.println("java JcaCertificateFactoryTest input output");
            return;
        }
        String input = a[0];
        String output = a[1];
        try {
            JcaCertificateTest.test(input, output);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            return;
        }
    }

    private static void test(String input, String output) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        System.out.println();
        System.out.println("CertificateFactory Object Info: ");
        System.out.println("Type = " + cf.getType());
        System.out.println("Provider = " + cf.getProvider());
        System.out.println("toString = " + cf.toString());
        FileInputStream fis = new FileInputStream(input);
        Certificate cert = cf.generateCertificate(fis);
        fis.close();
        System.out.println();
        System.out.println("Certificate Object Info: ");
        System.out.println("Type = " + cert.getType());
        System.out.println("toString = " + cert.toString());
        PublicKey pubKey = cert.getPublicKey();
        System.out.println();
        System.out.println("PublicKey Object Info: ");
        System.out.println("Algorithm = " + pubKey.getAlgorithm());
        System.out.println("Format = " + pubKey.getFormat());
        System.out.println("toString = " + pubKey.toString());
        FileOutputStream fos = new FileOutputStream(output);
        byte[] certBytes = cert.getEncoded();
        fos.write(certBytes);
        fos.close();
    }
}

