/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate.extension;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.certificate.oid.OIDGeneric;
import x2br.security.certificate.oid.OID_2_16_76_1_3_1;
import x2br.security.certificate.oid.OID_2_16_76_1_3_2;
import x2br.security.certificate.oid.OID_2_16_76_1_3_3;
import x2br.security.certificate.oid.OID_2_16_76_1_3_4;
import x2br.security.certificate.oid.OID_2_16_76_1_3_5;
import x2br.security.certificate.oid.OID_2_16_76_1_3_6;
import x2br.security.certificate.oid.OID_2_16_76_1_3_7;
import x2br.security.certificate.oid.OID_2_16_76_1_3_8;
import x2br.security.certificate.oid.OID_2_16_76_1_3_9;

public class CertificateExtra {
    private static final Logger logger = LoggerFactory.getLogger(CertificateExtra.class);
    private static final Integer ZERO = 0;
    private static final Integer UM = 1;
    private String email = null;
    private final Map<String, OIDGeneric> extras = new HashMap<String, OIDGeneric>(0);

    public CertificateExtra(X509Certificate certificate) {
        try {
            if (certificate.getSubjectAlternativeNames() == null) {
                return;
            }
            for (List<?> list : certificate.getSubjectAlternativeNames()) {
                if (list.size() != 2) {
                    throw new Exception("O tamanho das informa\u00e7\u00f5es extras do certificado est\u00e1 incorreto");
                }
                Object object1 = list.get(0);
                Object object2 = list.get(1);
                if (!(object1 instanceof Integer)) {
                    throw new Exception("O valor n\u00e3o \u00e9 do tipo \"java.lang.Integer\"");
                }
                Integer tipo = (Integer)object1;
                if (tipo.equals(ZERO)) {
                    byte[] data = (byte[])object2;
                    OIDGeneric oidGeneric = OIDGeneric.getInstance(data);
                    this.extras.put(oidGeneric.getOid(), oidGeneric);
                    continue;
                }
                if (!tipo.equals(UM)) continue;
                this.email = (String)object2;
            }
        }
        catch (CertificateParsingException ex) {
            logger.info(ex.getMessage());
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
        }
    }

    public boolean isCertificatePF() {
        return this.extras.get("2.16.76.1.3.1") != null;
    }

    public boolean isCertificatePJ() {
        return this.extras.get("2.16.76.1.3.7") != null;
    }

    public boolean isCertificateEquipment() {
        return this.extras.get("2.16.76.1.3.8") != null;
    }

    public OID_2_16_76_1_3_1 getOID_2_16_76_1_3_1() {
        return (OID_2_16_76_1_3_1)this.extras.get("2.16.76.1.3.1");
    }

    public OID_2_16_76_1_3_5 getOID_2_16_76_1_3_5() {
        return (OID_2_16_76_1_3_5)this.extras.get("2.16.76.1.3.5");
    }

    public OID_2_16_76_1_3_6 getOID_2_16_76_1_3_6() {
        return (OID_2_16_76_1_3_6)this.extras.get("2.16.76.1.3.6");
    }

    public OID_2_16_76_1_3_2 getOID_2_16_76_1_3_2() {
        return (OID_2_16_76_1_3_2)this.extras.get("2.16.76.1.3.2");
    }

    public OID_2_16_76_1_3_3 getOID_2_16_76_1_3_3() {
        return (OID_2_16_76_1_3_3)this.extras.get("2.16.76.1.3.3");
    }

    public OID_2_16_76_1_3_4 getOID_2_16_76_1_3_4() {
        return (OID_2_16_76_1_3_4)this.extras.get("2.16.76.1.3.4");
    }

    public OID_2_16_76_1_3_7 getOID_2_16_76_1_3_7() {
        return (OID_2_16_76_1_3_7)this.extras.get("2.16.76.1.3.7");
    }

    public OID_2_16_76_1_3_8 getOID_2_16_76_1_3_8() {
        return (OID_2_16_76_1_3_8)this.extras.get("2.16.76.1.3.8");
    }

    public OID_2_16_76_1_3_9 getOID_2_16_76_1_3_9() {
        return (OID_2_16_76_1_3_9)this.extras.get("2.16.76.1.3.9");
    }

    public String getEmail() {
        return this.email;
    }
}

