/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.ui.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import x2br.security.signer.ui.model.Json;

public class Message {
    private final String apiVersion = "1.0.1";
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm a z");
    private Data data;
    private Error error;

    public static DateFormat getDf() {
        return df;
    }

    public static void setDf(DateFormat aDf) {
        df = aDf;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public String toString() {
        return Json.exec().toJson(this);
    }

    public static void main(String[] args) throws ParseException {
        String json = "{\"apiVersion\":\"1.0.1\",\"data\":{\"certs\":[{\"ac\":\"CN=AC Certisign RFB G4, OU=Secretaria da Receita Federal do Brasil - RFB, O=ICP-Brasil, C=BR\",\"sn\":\"41458BFFF810F1793F0653B10EBEDC56\",\"name\":\"MARCO ANTONIO FERREIRA DE CARVALHO\",\"cpf\":\"20263597504\",\"email\":\"marco.carvalho@mprj.mp.br\",\"validate\":{\"startDate\":\"2015-04-27 21:00 PM BRT\",\"endDate\":\"2018-04-26 20:59 PM BRT\"}}]},\"error\":{\"code\":\"401\",\"message\":\"teste error\"}}";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm a z");
        Message x = Json.exec().fromJson(json, Message.class);
        System.out.println("Certificado:" + x.getData().getCerts());
        System.out.println("Message: " + x);
    }

    private static boolean isValid(String cert) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm a z");
            Map x = Json.exec().fromJson(cert, Map.class);
            String datas = (String)((Map)x.get("validate")).get("endDate");
            System.out.println("dats:" + datas);
            Date currentDate = df.parse(datas);
            return System.currentTimeMillis() < currentDate.getTime();
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static class Validate {
        private final Date startDate;
        private final Date endDate;

        public Validate(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public String toString() {
            return Json.exec().toJson(this);
        }
    }

    public static class Error {
        private final String code;
        private final String message;

        public Error(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return Json.exec().toJson(this);
        }
    }

    public static class Certificate {
        private String ac;
        private String sn;
        private String name;
        private String cpf;
        private String email;
        private Validate validate;

        public Certificate(String ac, String sn, String name, String cpf, String email, Validate validate) {
            this.ac = ac;
            this.sn = sn;
            this.name = name;
            this.cpf = cpf;
            this.email = email;
            this.validate = validate;
            System.out.println("ac:" + ac);
            System.out.println("sn:" + sn);
            System.out.println("name:" + name);
            System.out.println("cpf:" + cpf);
            System.out.println("email:" + email);
            System.out.println("validate:" + validate);
        }

        public String getAc() {
            return this.ac;
        }

        public void setAc(String ac) {
            this.ac = ac;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCpf() {
            return this.cpf;
        }

        public void setCpf(String cpf) {
            this.cpf = cpf;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public Validate getValidate() {
            return this.validate;
        }

        public void setValidate(Validate validate) {
            this.validate = validate;
        }

        public String toString() {
            return Json.exec().toJson(this);
        }
    }

    public static class Data {
        private ArrayList<Certificate> certs = new ArrayList();

        public String toString() {
            return Json.exec().toJson(this);
        }

        public ArrayList<Certificate> getCerts() {
            return this.certs;
        }

        public void addCerts(Certificate cert) {
            this.certs.add(cert);
        }
    }
}

