/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop.splash;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SplashDemo
extends Frame
implements ActionListener {
    private static WindowListener closeWindow = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            e.getWindow().dispose();
        }
    };

    static void renderSplashFrame(Graphics2D g, int frame) {
        String[] comps = new String[]{"foo", "bar", "baz"};
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(120, 140, 200, 40);
        g.setPaintMode();
        g.setColor(Color.BLACK);
        g.drawString("Loading " + comps[frame / 5 % 3] + "...", 120, 150);
    }

    public SplashDemo() {
        super("SplashScreen demo");
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        Menu m1 = new Menu("File");
        MenuItem mi1 = new MenuItem("Exit");
        m1.add(mi1);
        mi1.addActionListener(this);
        this.addWindowListener(closeWindow);
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        mb.add(m1);
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash == null) {
            System.out.println("SplashScreen.getSplashScreen() returned null");
            return;
        }
        Graphics2D g = splash.createGraphics();
        if (g == null) {
            System.out.println("g is null");
            return;
        }
        for (int i = 0; i < 100; ++i) {
            SplashDemo.renderSplashFrame(g, i);
            splash.update();
            try {
                Thread.sleep(90L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        splash.close();
        this.setVisible(true);
        this.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        System.exit(0);
    }

    public static void main(String[] args) {
        SplashDemo test = new SplashDemo();
    }
}

