/*
 * Decompiled with CFR 0.152.
 */
package panda.signer;

import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class Generator {
    private static final int KEY_BITS = 1024;

    public final File generateKeypair(String path) {
        File selectedDirectory = new File(path);
        String pathToKeyDirectory = selectedDirectory.getAbsolutePath();
        this.generateKeys(path);
        return selectedDirectory;
    }

    public final File generateKeypair() {
        return this.generateKeypair("./");
    }

    private void generateKeys(String folder) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
            keyGen.initialize(1024);
            KeyPair pair = keyGen.generateKeyPair();
            PrivateKey priv = pair.getPrivate();
            PublicKey pub = pair.getPublic();
            byte[] key = pub.getEncoded();
            this.keyWriter(folder + "/pub", key);
            byte[] key2 = priv.getEncoded();
            key2 = priv.getEncoded();
            this.keyWriter(folder + "/priv", key2);
            System.out.println("++ keys generated");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private void keyWriter(String path, byte[] key) {
        try (FileOutputStream keyfos = new FileOutputStream(path);){
            keyfos.write(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

