/*
 * Decompiled with CFR 0.152.
 */
package panda.signer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import panda.signer.PrivatekeyReader;
import panda.signer.Utils;

public class Signer {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private String privateKeyPath;

    public final void createSignFile(String privatekeyFolderPath, String local) {
        this.privateKeyPath = privatekeyFolderPath;
        Properties prop = new Properties();
        ArrayList<File> fileList = null;
        String sigFilePath = local + "/sig.properties";
        try (FileOutputStream output = new FileOutputStream(sigFilePath);){
            fileList = new ArrayList<File>();
            Utils.listFiles(local, fileList);
            String signaturecombination = "";
            for (File file : fileList) {
                String fileName = file.getName();
                try {
                    String md5Checksum = Utils.getHashOfFile(file);
                    prop.setProperty(fileName, md5Checksum);
                    signaturecombination = signaturecombination + md5Checksum;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            String signature = this.createSignature(signaturecombination.getBytes());
            prop.setProperty("Signature", signature);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private String createSignature(byte[] file) {
        byte[] byteArraySignature = null;
        try {
            PrivatekeyReader privateKeyReader = new PrivatekeyReader();
            PrivateKey privateKey = privateKeyReader.get(this.privateKeyPath);
            Signature signature = Signature.getInstance("SHAwithDSA");
            signature.initSign(privateKey);
            signature.update(file);
            byteArraySignature = signature.sign();
            System.out.println("Signature is: " + new String(Base64.encodeBase64(byteArraySignature), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] encryptedByteValue = Base64.encodeBase64(byteArraySignature);
        String returner = new String(encryptedByteValue, DEFAULT_CHARSET);
        return returner;
    }
}

