/*
 * Decompiled with CFR 0.152.
 */
package x2br.app;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AppLoader {
    static final String AppDirName = "SnapCode";
    static final String JarName = "SnapCode1.jar";
    static final String JarURL = "http://reportmill.com/snap1/SnapCode1.jar.pack.gz";
    static final String MainClass = "snap.app.App";
    static boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    static boolean isMac = System.getProperty("os.name").indexOf("Mac OS X") >= 0;

    public static void main(String[] args) {
        try {
            AppLoader.main1(args);
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString());
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) throws Exception {
        try {
            AppLoader.copyDefaultMainJar();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString());
            e.printStackTrace();
        }
        File jar = AppLoader.getAppFile(JarName);
        File updateJar = AppLoader.getAppFile("SnapCode1.jar.update");
        if (updateJar.exists()) {
            AppLoader.copyFile(updateJar, jar);
            jar.setLastModified(updateJar.lastModified());
            updateJar.delete();
        }
        if (!jar.exists() || !jar.canRead()) {
            throw new RuntimeException("Main Jar not found!");
        }
        if (args.length == 0 || !args[0].equals("-snap")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AppLoader.checkForUpdatesSilent();
                }
            }).start();
        }
        URLClassLoader ucl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> cls = ucl.loadClass(MainClass);
        Method meth = cls.getMethod("main", String[].class);
        meth.invoke(null, new Object[]{args});
        if (cls == Object.class) {
            ucl.close();
        }
    }

    private static void copyDefaultMainJar() throws IOException, ParseException {
        URL url = AppLoader.class.getProtectionDomain().getCodeSource().getLocation();
        String path0 = url.getPath();
        path0 = URLDecoder.decode(path0, "UTF-8");
        File jar0 = AppLoader.getAppFile(JarName);
        File jar1 = new File(path0);
        if (jar0.exists() && jar0.lastModified() >= jar1.lastModified()) {
            return;
        }
        AppLoader.copyFile(jar1, jar0);
    }

    private static void checkForUpdatesSilent() {
        try {
            AppLoader.checkForUpdates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkForUpdates() throws IOException, MalformedURLException {
        long mod1;
        File jarFile = AppLoader.getAppFile(JarName);
        URL url = new URL(JarURL);
        URLConnection connection = url.openConnection();
        long mod0 = jarFile.lastModified();
        if (mod0 >= (mod1 = connection.getLastModified())) {
            System.out.println("No update available at http://reportmill.com/snap1/SnapCode1.jar.pack.gz(" + mod0 + '>' + mod1 + ')');
            return;
        }
        System.out.println("Loading update from http://reportmill.com/snap1/SnapCode1.jar.pack.gz");
        byte[] bytes = AppLoader.getBytes(connection);
        System.out.println("Update loaded");
        File updatePacked = AppLoader.getAppFile("SnapCode1.jar.pack.gz");
        File updateFile = AppLoader.getAppFile("SnapCode1.jar.update");
        AppLoader.writeBytes(updatePacked, bytes);
        System.out.println("Update saved: " + updatePacked);
        AppLoader.unpack(updatePacked, updateFile);
        System.out.println("Update unpacked: " + updateFile);
        updateFile.setLastModified(mod1);
        updatePacked.delete();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "A new update is available. Restart application to apply");
            }
        });
    }

    private static File getAppFile(String aName) {
        return new File(AppLoader.getAppDir(), aName);
    }

    private static File getAppDir() {
        return AppLoader.getAppDataDir(AppDirName, true);
    }

    public static File copyFile(File aSource, File aDest) throws IOException {
        FileInputStream fis = new FileInputStream(aSource);
        File out = aDest.isDirectory() ? new File(aDest, aSource.getName()) : aDest;
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[8192];
        int i = fis.read(buf);
        while (i != -1) {
            fos.write(buf, 0, i);
            i = fis.read(buf);
        }
        fis.close();
        fos.close();
        return out;
    }

    public static void writeBytes(File aFile, byte[] theBytes) throws IOException {
        if (theBytes == null) {
            aFile.delete();
            return;
        }
        FileOutputStream fileStream = new FileOutputStream(aFile);
        fileStream.write(theBytes);
        fileStream.close();
    }

    public static File unpack(File aFile, File aDestFile) throws IOException {
        File destFile = AppLoader.getUnpackDestination(aFile, aDestFile);
        if (destFile.exists() && destFile.lastModified() > aFile.lastModified()) {
            return destFile;
        }
        FileInputStream fileInput = new FileInputStream(aFile);
        GZIPInputStream gzipInput = new GZIPInputStream(fileInput);
        FileOutputStream fileOut = new FileOutputStream(destFile);
        JarOutputStream jarOut = new JarOutputStream(fileOut);
        Pack200.newUnpacker().unpack((InputStream)gzipInput, jarOut);
        fileInput.close();
        gzipInput.close();
        jarOut.close();
        fileOut.close();
        return destFile;
    }

    public static File getUnpackDestination(File aFile, File aDestFile) {
        File destFile = aDestFile;
        if (destFile == null) {
            destFile = new File(aFile.getPath().replace(".pack.gz", ""));
        } else if (destFile.isDirectory()) {
            destFile = new File(destFile, aFile.getName().replace(".pack.gz", ""));
        }
        return destFile;
    }

    public static File getAppDataDir(String aName, boolean doCreate) {
        String dir = System.getProperty("user.home");
        if (isWindows) {
            dir = dir + File.separator + "AppData" + File.separator + "Local";
        } else if (isMac) {
            dir = dir + File.separator + "Library" + File.separator + "Application Support";
        }
        if (aName != null) {
            dir = dir + File.separator + aName;
        }
        File dfile = new File(dir);
        if (doCreate && aName != null) {
            dfile.mkdirs();
        }
        return dfile;
    }

    public static byte[] getBytes(URLConnection aConnection) throws IOException {
        InputStream stream = aConnection.getInputStream();
        byte[] bytes = AppLoader.getBytes(stream);
        stream.close();
        return bytes;
    }

    public static byte[] getBytes(InputStream aStream) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] chunk = new byte[8192];
        int len = aStream.read(chunk, 0, 8192);
        while (len > 0) {
            bs.write(chunk, 0, len);
            len = aStream.read(chunk, 0, 8192);
        }
        return bs.toByteArray();
    }
}

