/*
 * Decompiled with CFR 0.152.
 */
package x2br.app;

import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class FadeApp
extends Application {
    public static final String APPLICATION_ICON = "http://cdn1.iconfinder.com/data/icons/Copenhagen/PNG/32/people.png";
    public static final String SPLASH_IMAGE = "http://fxexperience.com/wp-content/uploads/2010/06/logo.png";
    private Pane splashLayout;
    private ProgressBar loadProgress;
    private Label progressText;
    private Stage mainStage;
    private static final int SPLASH_WIDTH = 676;
    private static final int SPLASH_HEIGHT = 227;

    public static void main(String[] args) throws Exception {
        FadeApp.launch((String[])args);
    }

    public void init() {
        ImageView splash = new ImageView(new Image(SPLASH_IMAGE));
        this.loadProgress = new ProgressBar();
        this.loadProgress.setPrefWidth(656.0);
        this.progressText = new Label("Will find friends for peanuts . . .");
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{splash, this.loadProgress, this.progressText});
        this.progressText.setAlignment(Pos.CENTER);
        this.splashLayout.setStyle("-fx-padding: 5; -fx-background-color: cornsilk; -fx-border-width:5; -fx-border-color: linear-gradient(to bottom, chocolate, derive(chocolate, 50%));");
        this.splashLayout.setEffect((Effect)new DropShadow());
    }

    public void start(Stage initStage) throws Exception {
        Task<ObservableList<String>> friendTask = new Task<ObservableList<String>>(){

            protected ObservableList<String> call() throws InterruptedException {
                ObservableList foundFriends = FXCollections.observableArrayList();
                ObservableList availableFriends = FXCollections.observableArrayList((Object[])new String[]{"Fili", "Kili", "Oin", "Gloin", "Thorin", "Dwalin", "Balin", "Bifur", "Bofur", "Bombur", "Dori", "Nori", "Ori"});
                this.updateMessage("Finding friends . . .");
                for (int i = 0; i < availableFriends.size(); ++i) {
                    Thread.sleep(400L);
                    this.updateProgress(i + 1, availableFriends.size());
                    String nextFriend = (String)availableFriends.get(i);
                    foundFriends.add((Object)nextFriend);
                    this.updateMessage("Finding friends . . . found " + nextFriend);
                }
                Thread.sleep(400L);
                this.updateMessage("All friends found.");
                return foundFriends;
            }
        };
        this.showSplash(initStage, friendTask, () -> this.lambda$start$0((Task)friendTask));
        new Thread((Runnable)friendTask).start();
    }

    private void showMainStage(ReadOnlyObjectProperty<ObservableList<String>> friends) {
        this.mainStage = new Stage(StageStyle.DECORATED);
        this.mainStage.setTitle("My Friends");
        this.mainStage.getIcons().add((Object)new Image(APPLICATION_ICON));
        ListView peopleView = new ListView();
        peopleView.itemsProperty().bind(friends);
        this.mainStage.setScene(new Scene((Parent)peopleView));
        this.mainStage.show();
    }

    private void showSplash(Stage initStage, Task<?> task, InitCompletionHandler initCompletionHandler) {
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.loadProgress.progressProperty().unbind();
                this.loadProgress.setProgress(1.0);
                initStage.toFront();
                FadeTransition fadeSplash = new FadeTransition(Duration.seconds((double)1.2), (Node)this.splashLayout);
                fadeSplash.setFromValue(1.0);
                fadeSplash.setToValue(0.0);
                fadeSplash.setOnFinished(actionEvent -> initStage.hide());
                fadeSplash.play();
                initCompletionHandler.complete();
            }
        });
        Scene splashScene = new Scene((Parent)this.splashLayout, (Paint)Color.TRANSPARENT);
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        initStage.setScene(splashScene);
        initStage.setX(bounds.getMinX() + bounds.getWidth() / 2.0 - 338.0);
        initStage.setY(bounds.getMinY() + bounds.getHeight() / 2.0 - 113.0);
        initStage.initStyle(StageStyle.TRANSPARENT);
        initStage.setAlwaysOnTop(true);
        initStage.show();
    }

    private /* synthetic */ void lambda$start$0(Task friendTask) {
        this.showMainStage((ReadOnlyObjectProperty<ObservableList<String>>)friendTask.valueProperty());
    }

    public static interface InitCompletionHandler {
        public void complete();
    }
}

