/*
 * Decompiled with CFR 0.152.
 */
package x2br.app;

import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class LoadTimer
extends Application {
    public static void main(String[] args) {
        LoadTimer.launch((String[])args);
    }

    public void start(Stage stage) {
        WebView webview = new WebView();
        VBox layout = new VBox();
        layout.getChildren().setAll((Object[])new Node[]{this.createProgressReport(webview.getEngine()), webview});
        stage.setScene(new Scene((Parent)layout));
        stage.show();
        webview.getEngine().load("http://www.fxexperience.com");
    }

    private HBox createProgressReport(WebEngine engine) {
        SimpleLongProperty startTime = new SimpleLongProperty();
        SimpleLongProperty endTime = new SimpleLongProperty();
        SimpleLongProperty elapsedTime = new SimpleLongProperty();
        ProgressBar loadProgress = new ProgressBar();
        loadProgress.progressProperty().bind((ObservableValue)engine.getLoadWorker().progressProperty());
        Label loadTimeLabel = new Label();
        loadTimeLabel.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)elapsedTime.greaterThan(0)).then((ObservableStringValue)Bindings.concat((Object[])new Object[]{"Loaded page in ", elapsedTime.divide(1000000), "ms"})).otherwise("Loading..."));
        elapsedTime.bind((ObservableValue)Bindings.subtract((ObservableNumberValue)endTime, (ObservableNumberValue)startTime));
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>((LongProperty)startTime, (LongProperty)endTime){
            final /* synthetic */ LongProperty val$startTime;
            final /* synthetic */ LongProperty val$endTime;
            {
                this.val$startTime = longProperty;
                this.val$endTime = longProperty2;
            }

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State oldState, Worker.State state) {
                switch (state) {
                    case RUNNING: {
                        this.val$startTime.set(System.nanoTime());
                        break;
                    }
                    case SUCCEEDED: {
                        this.val$endTime.set(System.nanoTime());
                    }
                }
            }
        });
        HBox progressReport = new HBox(10.0);
        progressReport.getChildren().setAll((Object[])new Node[]{loadProgress, loadTimeLabel});
        progressReport.setPadding(new Insets(5.0));
        progressReport.setAlignment(Pos.CENTER_LEFT);
        return progressReport;
    }
}

