/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.application;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javafx.scene.control.Alert;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

public class AppUpdateManager {
    private final String remotePath;
    private final String localPath;
    private Git git;
    static final Logger logger = Logger.getLogger(AppUpdateManager.class);

    public AppUpdateManager(String localPath, String remotePath) {
        this.remotePath = remotePath;
        this.localPath = localPath;
    }

    private void initialDownload() {
        try {
            this.git = Git.cloneRepository().setURI(this.remotePath).setDirectory(new File(this.localPath)).call();
            System.out.println("+App installed into: " + this.localPath);
        }
        catch (GitAPIException ex) {
            System.err.println("--Cannot download files: " + ex.getMessage());
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, "Cannot download files: " + ex.getMessage(), "Error", 0);
        }
    }

    private void update() {
        try {
            this.git.revert();
            CleanCommand setCleanDirectories = this.git.clean().setCleanDirectories(true);
            setCleanDirectories.call();
            setCleanDirectories.call();
            System.out.println("clean directories");
            this.git.clean().call();
            this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
            System.out.println("+Changed and unnecessary files removed");
        }
        catch (GitAPIException ex) {
            throw new IllegalStateException("Cannot reset local repository", ex);
        }
        PullCommand command = this.git.pull();
        try {
            PullResult pullResult = command.call();
            if (pullResult.isSuccessful()) {
                System.out.println("+Files updated, ready to start!");
            } else {
                System.out.println("--Download was not successful " + pullResult.toString());
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Error Dialog");
                alert.setHeaderText("Look, an Error Dialog");
                alert.setContentText("Ooops, there was an error!");
                alert.showAndWait();
            }
        }
        catch (GitAPIException ex) {
            logger.error(ex);
        }
    }

    private boolean openLocal() {
        System.out.println("this.localPath = " + this.localPath);
        File localRepo = new File(this.localPath);
        try {
            this.git = Git.open(localRepo);
        }
        catch (IOException ex) {
            System.out.println("-" + ex.getMessage());
            return false;
        }
        System.out.println("+Application already installed at: " + this.localPath);
        return true;
    }

    public final void installOrUpdate() {
        boolean alreadyInstalled = this.openLocal();
        if (alreadyInstalled) {
            this.update();
        } else {
            this.initialDownload();
        }
    }
}

