/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.application;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import javax.swing.JOptionPane;
import x2br.app.util.FileUtils;

public class ProgramStarter {
    private static final String FILE_WEB_DESKTOP = "WebDesktop.jar";
    private static final String FILE_APP_LAUNCHER = "AppLauncher.exe";
    private static final String APP_PATH = "app" + File.separator;
    private static final String JAVA_JRE = "jre" + File.separator + "bin" + File.separator + "javaw";
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private String path = this.getPath();
    private static final int SUBSTRING_BEGIN_INDEX = 9;
    static final Logger logger = Logger.getLogger(ProgramStarter.class.getName());

    public ProgramStarter() {
        System.out.println("path: " + this.path);
    }

    private String getPath() {
        String current = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + File.separator;
        return current;
    }

    public final void startProgramm() {
        ProgramStarter.updateAppLauncher();
        ProgramStarter.updateWebDesktop();
        if (ProgramStarter.isWindows()) {
            System.out.println("This is Windows");
            this.startBatch();
        } else if (ProgramStarter.isMac()) {
            System.out.println("This is Mac");
            this.startMacShell();
        } else if (ProgramStarter.isUnix()) {
            System.out.println("This is Unix or Linux");
            this.startShell();
        } else {
            System.out.println("Your OS is not support!");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("SO n\u00e3o suportado!");
            alert.setHeaderText("Seu sistema operacional n\u00e3o \u00e9 suportado.");
            alert.setContentText("Parece que n\u00e3o suportamos o seu sistema operacional, desculpe por isso. Verifique a p\u00e1gina do AppLauncher no gitlab e deixe um coment\u00e1rio com as seguintes informa\u00e7\u00f5es: OS =" + OS);
            alert.showAndWait();
            logger.severe(String.format("Confira a \u00faltima p\u00e1gina final do AppLauncher no gitlab e deixe um coment\u00e1rio com a seguinte informa\u00e7\u00e3o: OS=%s", OS));
        }
        System.exit(0);
    }

    private void startBatch() {
        try {
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            String command = JAVA_JRE + " -jar " + FILE_WEB_DESKTOP;
            System.out.println("command: " + command);
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new Frame(), e.toString(), "Error", 0);
        }
    }

    private void startMacShell() {
        try {
            new File(this.path + "app/startM.sh").setExecutable(true);
            new ProcessBuilder(this.path + "app/startM.sh").start();
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
            logger.severe(e.getMessage());
        }
    }

    private void startShell() {
        try {
            new File(this.path + "app/startL.sh").setExecutable(true);
            new ProcessBuilder(this.path + "app/startL.sh").start();
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
            logger.severe(e.getMessage());
        }
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static void updateAppLauncher() {
        File newFile = new File(APP_PATH + FILE_APP_LAUNCHER);
        File actualFile = new File(FILE_APP_LAUNCHER);
        if (newFile.exists() && newFile.lastModified() != actualFile.lastModified() || !actualFile.exists()) {
            try {
                System.out.println("Autializando AppLauncher.exe...");
                FileUtils.copyFileUsingStream(newFile, actualFile);
                System.out.println("Atualiza\u00e7\u00e3o ok!");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void updateWebDesktop() {
        File newFile = new File(APP_PATH + FILE_WEB_DESKTOP);
        File actualFile = new File(FILE_WEB_DESKTOP);
        if (newFile.exists() && newFile.lastModified() != actualFile.lastModified() || !actualFile.exists()) {
            try {
                System.out.println("Autializando WebDesktop.jar...");
                FileUtils.copyFileUsingStream(newFile, actualFile);
                System.out.println("Atualiza\u00e7\u00e3o ok!");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void callWebDesktop() {
        System.out.println("Executar o  WebDesktop.jar");
        try {
            File actualFile = new File(FILE_WEB_DESKTOP);
            JarFile jarFile = new JarFile(actualFile);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String className = attributes.getValue(Attributes.Name.MAIN_CLASS);
            URL[] urls = new URL[]{actualFile.toURI().toURL()};
            URLClassLoader child = new URLClassLoader(urls, ProgramStarter.class.getClassLoader());
            Class<?> clazz = Class.forName(className, true, child);
            Method meth = clazz.getMethod("main", String[].class);
            String[] params = new String[]{};
            meth.invoke(null, new Object[]{params});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

