/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.application;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PropertiesHandler {
    private final Properties properties = new Properties();
    static final Logger logger = Logger.getLogger(PropertiesHandler.class);

    public PropertiesHandler() {
        try (BufferedInputStream stream = new BufferedInputStream(PropertiesHandler.class.getClassLoader().getResourceAsStream("config.properties"));){
            this.properties.load(stream);
        }
        catch (FileNotFoundException e1) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, "Propriedades n\u00e3o encontradas! ./config.properties", "Error", 0);
            logger.error(e1);
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
            logger.error(e);
        }
    }

    public final String getFolder() {
        String folder = this.properties.getProperty("folder");
        if (folder == null || folder.isEmpty()) {
            folder = "app";
        }
        return folder;
    }

    public final String getGit() throws Exception {
        String git = this.properties.getProperty("git");
        if (git == null || git.isEmpty()) {
            logger.error("Um caminho v\u00e1lido para um reposit\u00f3rio git deve ser especificado!");
            throw new Exception("Um caminho v\u00e1lido para um reposit\u00f3rio git deve ser especificado!");
        }
        return git;
    }
}

