/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.ZipFile;
import x2br.app.util.OS;

public class FileUtils {
    static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    public static final int BUFFER_SIZE = 65536;

    public static String getRootAppPath() {
        String current = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + File.separator;
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    public static void copyFileUsingJava7Files(File source, File dest) throws IOException {
        Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
    }

    public static long getChecksum(Path path) throws IOException {
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            Adler32 checksum = new Adler32();
            byte[] buf = new byte[1024];
            while ((read = input.read(buf, 0, buf.length)) > -1) {
                checksum.update(buf, 0, read);
            }
            long l = checksum.getValue();
            return l;
        }
    }

    public static String getChecksumString(Path path) throws IOException {
        return Long.toHexString(FileUtils.getChecksum(path));
    }

    public static boolean isJarFile(Path path) throws IOException {
        if (!FileUtils.isZipFile(path)) {
            return false;
        }
        try (ZipFile zip = new ZipFile(path.toFile());){
            boolean bl = zip.getEntry("META-INF/MANIFEST.MF") != null;
            return bl;
        }
    }

    public static boolean isZipFile(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isReadable(path)) {
            throw new IOException("Cannot read file " + path.toAbsolutePath());
        }
        if (Files.size(path) < 4L) {
            return false;
        }
        try (DataInputStream in = new DataInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int test = in.readInt();
            boolean bl = test == 1347093252;
            return bl;
        }
    }

    public static byte[] sign(Path path, PrivateKey key) throws IOException {
        try {
            Signature sign = Signature.getInstance("SHA256with" + key.getAlgorithm());
            sign.initSign(key);
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = input.read(buf, 0, buf.length)) > 0) {
                    sign.update(buf, 0, len);
                }
            }
            return sign.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String signAndEncode(Path path, PrivateKey key) throws IOException {
        return Base64.getEncoder().encodeToString(FileUtils.sign(path, key));
    }

    public static Path fromUri(URI uri) {
        String path = uri.getPath();
        if (uri.isAbsolute()) {
            path = path.substring(path.lastIndexOf("/") + 1);
        }
        return Paths.get(path, new String[0]);
    }

    public static URI fromPath(Path path) {
        if (path.isAbsolute()) {
            Path filename = path.getFileName();
            return FileUtils.fromPath(filename);
        }
        try {
            String uri = URLEncoder.encode(path.toString().replace("\\", "/"), "UTF-8");
            uri = uri.replace("%2F", "/").replace("+", "%20");
            return URI.create(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static URI relativize(URI base, URI other) {
        if (base == null || other == null) {
            return other;
        }
        return base.relativize(other);
    }

    public static Path relativize(Path base, Path other) {
        if (base == null || other == null) {
            return other;
        }
        try {
            return base.relativize(other);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return other;
        }
    }

    public static OS fromFilename(String filename) {
        Pattern osPattern = Pattern.compile(".+-(linux|win|mac)\\.[^.]+");
        Matcher osMatcher = osPattern.matcher(filename);
        if (osMatcher.matches()) {
            return OS.fromShortName(osMatcher.group(1));
        }
        return null;
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
                boolean bl = !dir.iterator().hasNext();
                return bl;
            }
        }
        return false;
    }

    public static void windowsHide(Path file) {
        try {
            Files.setAttribute(file, "dos:hidden", true, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void windowsUnhide(Path file) {
        try {
            Files.setAttribute(file, "dos:hidden", false, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void verifyNotLocked(Path path) throws IOException {
        if (OS.CURRENT != OS.WINDOWS) {
            return;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        Path temp = Files.createTempFile(path.getParent(), null, null, new FileAttribute[0]);
        try {
            Files.move(path, temp, StandardCopyOption.REPLACE_EXISTING);
            Files.move(temp, path, new CopyOption[0]);
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static void secureMoveFile(Path source, Path target) throws IOException {
        if (OS.CURRENT == OS.WINDOWS || Files.notExists(target, new LinkOption[0])) {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        Path temp = Files.createTempFile(target.getParent(), null, null, new FileAttribute[0]);
        Files.move(target, temp, StandardCopyOption.REPLACE_EXISTING);
        try {
            Files.move(source, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.move(temp, target, new CopyOption[0]);
            throw e;
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static String md5Sum(File file) {
        String checksum = null;
        try {
            int numOfBytesRead;
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((numOfBytesRead = fis.read(buffer)) > 0) {
                md.update(buffer, 0, numOfBytesRead);
            }
            byte[] hash = md.digest();
            checksum = new BigInteger(1, hash).toString(16);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileBinaryEqual(File first, File second) throws IOException {
        boolean retval;
        block14: {
            retval = false;
            if (first.exists() && second.exists() && first.isFile() && second.isFile()) {
                if (first.getCanonicalPath().equals(second.getCanonicalPath())) {
                    retval = true;
                } else {
                    FileInputStream firstInput = null;
                    FileInputStream secondInput = null;
                    BufferedInputStream bufFirstInput = null;
                    BufferedInputStream bufSecondInput = null;
                    try {
                        int secondByte;
                        int firstByte;
                        firstInput = new FileInputStream(first);
                        secondInput = new FileInputStream(second);
                        bufFirstInput = new BufferedInputStream(firstInput, 65536);
                        bufSecondInput = new BufferedInputStream(secondInput, 65536);
                        do {
                            if ((firstByte = bufFirstInput.read()) == (secondByte = bufSecondInput.read())) continue;
                            break block14;
                        } while (firstByte >= 0 || secondByte >= 0);
                        retval = true;
                    }
                    finally {
                        try {
                            if (bufFirstInput != null) {
                                bufFirstInput.close();
                            }
                        }
                        finally {
                            if (bufSecondInput != null) {
                                bufSecondInput.close();
                            }
                        }
                    }
                }
            }
        }
        return retval;
    }
}

